<?php

// Function to perform a cURL request to fetch the page content
function curlGet($url) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    $response = curl_exec($ch);
    curl_close($ch);
    return $response;
}

// Step 1: Fetch the HTML content from the main URL
$pageUrl = "https://www.livescore.com/en/";
$htmlContent = curlGet($pageUrl);

// Step 2: Use a regex to find the script URL that contains '_next/static/' followed by a dynamic key
preg_match('/_next\/static\/([a-zA-Z0-9_-]+)\/_buildManifest\.js/', $htmlContent, $matches);

if (!isset($matches[1])) {
    die("Dynamic key not found in the HTML content.\n");
}

// Step 3: Extract the dynamic key
$dynamicKey = $matches[1];

echo "Extracted Dynamic Key: " . $dynamicKey . "\n";

// // Step 4: (Optional) Fetch the build manifest file if needed
// $buildManifestUrl = "https://www.livescore.com/_next/static/{$dynamicKey}/_buildManifest.js";
// $buildManifestContent = curlGet($buildManifestUrl);

// // Output the content of the build manifest (or do further processing as needed)
// echo "Build Manifest Content: \n" . substr($buildManifestContent, 0, 500) . "..."; // Printing a sample of the content

?>