<?php 
$DATA = array();
$timenow = date('Y-m-d H:i:s');
$fordate = date('Ymd');
$fordate_formate = date('d/m/Y');
// ini_set('display_errors', 1); ini_set('display_startup_errors', 1); error_reporting(E_ALL); //on

///////////date function //////////////
function getHoursAndMinutes($datetime) {
    // Check if the datetime string is in the correct format
    if (strlen($datetime) !== 14 || !ctype_digit($datetime)) {
        return "Invalid datetime format. Expected format: YYYYMMDDHHMMSS";
    }

    // Extract hours and minutes
    $hours = substr($datetime, 8, 2); // Characters 9-10 are hours
    $minutes = substr($datetime, 10, 2); // Characters 11-12 are minutes

    // Return in "HH:MM" format
    return "{$hours}:{$minutes}";
}

function getDateAndMonth($datetime) {
    // Check if the datetime string is in the correct format
    if (strlen($datetime) !== 14 || !ctype_digit($datetime)) {
        return "Invalid datetime format. Expected format: YYYYMMDDHHMMSS";
    }

    // Extract day and month
    $day = substr($datetime, 6, 2); // Characters 7-8 are day
    $monthNum = substr($datetime, 4, 2); // Characters 5-6 are month

    // Convert numeric month to short name (e.g., 03 -> MAR)
    $monthNames = [
        "01" => "JAN", "02" => "FEB", "03" => "MAR", "04" => "APR",
        "05" => "MAY", "06" => "JUN", "07" => "JUL", "08" => "AUG",
        "09" => "SEP", "10" => "OCT", "11" => "NOV", "12" => "DEC"
    ];
    
    $month = $monthNames[$monthNum] ?? "Invalid Month";

    // Return in "DD MON" format
    return "{$day} {$month}";
}


function addHoursToDatetime($datetime, $hoursToAdd) {
    // Validate input format
    if (strlen($datetime) !== 14 || !ctype_digit($datetime)) {
        return "Invalid datetime format. Expected format: YYYYMMDDHHMMSS";
    }

    // Convert string to DateTime object
    $dateTimeObj = DateTime::createFromFormat('YmdHis', $datetime);
    if (!$dateTimeObj) {
        return "Invalid datetime format.";
    }

    // Convert decimal hours to total minutes
    $totalMinutes = $hoursToAdd * 60; // Convert total hours to minutes

    // Add minutes directly
    $dateTimeObj->modify("+{$totalMinutes} minutes");

    // Return updated datetime in the same format
    return $dateTimeObj->format('YmdHis');
}


////////////date function end/////////////
// Function to get the client IP address
function get_client_ip() {
    $ipaddress = '';
    if (getenv('HTTP_CLIENT_IP'))
        $ipaddress = getenv('HTTP_CLIENT_IP');
    else if(getenv('HTTP_X_FORWARDED_FOR'))
        $ipaddress = getenv('HTTP_X_FORWARDED_FOR');
    else if(getenv('HTTP_X_FORWARDED'))
        $ipaddress = getenv('HTTP_X_FORWARDED');
    else if(getenv('HTTP_FORWARDED_FOR'))
        $ipaddress = getenv('HTTP_FORWARDED_FOR');
    else if(getenv('HTTP_FORWARDED'))
       $ipaddress = getenv('HTTP_FORWARDED');
    else if(getenv('REMOTE_ADDR'))
        $ipaddress = getenv('REMOTE_ADDR');
    else
        $ipaddress = 'UNKNOWN';
    return $ipaddress;
}

// -----------------------------------------------

$countryToTimeZone = [
        'AF' => 'Asia/Kabul',
        'AL' => 'Europe/Tirane',
        'DZ' => 'Africa/Algiers',
        'AS' => 'Pacific/Pago_Pago',
        'AD' => 'Europe/Andorra',
        'AO' => 'Africa/Luanda',
        'AG' => 'America/Antigua',
        'AR' => 'America/Argentina/Buenos_Aires',
        'AM' => 'Asia/Yerevan',
        'AU' => 'Australia/Sydney',
        'AT' => 'Europe/Vienna',
        'AZ' => 'Asia/Baku',
        'BS' => 'America/Nassau',
        'BH' => 'Asia/Bahrain',
        'BD' => 'Asia/Dhaka',
        'BB' => 'America/Barbados',
        'BY' => 'Europe/Minsk',
        'BE' => 'Europe/Brussels',
        'BZ' => 'America/Belize',
        'BJ' => 'Africa/Porto-Novo',
        'BT' => 'Asia/Thimphu',
        'BO' => 'America/La_Paz',
        'BA' => 'Europe/Sarajevo',
        'BW' => 'Africa/Gaborone',
        'BR' => 'America/Sao_Paulo',
        'BN' => 'Asia/Brunei',
        'BG' => 'Europe/Sofia',
        'BF' => 'Africa/Ouagadougou',
        'BI' => 'Africa/Bujumbura',
        'KH' => 'Asia/Phnom_Penh',
        'CM' => 'Africa/Douala',
        'CA' => 'America/Toronto',
        'CV' => 'Atlantic/Cape_Verde',
        'CF' => 'Africa/Bangui',
        'TD' => 'Africa/Ndjamena',
        'CL' => 'America/Santiago',
        'CN' => 'Asia/Shanghai',
        'CO' => 'America/Bogota',
        'KM' => 'Indian/Comoro',
        'CG' => 'Africa/Brazzaville',
        'CR' => 'America/Costa_Rica',
        'CI' => 'Africa/Abidjan',
        'HR' => 'Europe/Zagreb',
        'CU' => 'America/Havana',
        'CY' => 'Asia/Nicosia',
        'CZ' => 'Europe/Prague',
        'DK' => 'Europe/Copenhagen',
        'DJ' => 'Africa/Djibouti',
        'DM' => 'America/Dominica',
        'DO' => 'America/Santo_Domingo',
        'EC' => 'America/Guayaquil',
        'EG' => 'Africa/Cairo',
        'SV' => 'America/El_Salvador',
        'GQ' => 'Africa/Malabo',
        'ER' => 'Africa/Asmara',
        'EE' => 'Europe/Tallinn',
        'ET' => 'Africa/Addis_Ababa',
        'FJ' => 'Pacific/Fiji',
        'FI' => 'Europe/Helsinki',
        'FR' => 'Europe/Paris',
        'GA' => 'Africa/Libreville',
        'GM' => 'Africa/Banjul',
        'GE' => 'Asia/Tbilisi',
        'DE' => 'Europe/Berlin',
        'GH' => 'Africa/Accra',
        'GR' => 'Europe/Athens',
        'GT' => 'America/Guatemala',
        'GN' => 'Africa/Conakry',
        'GW' => 'Africa/Bissau',
        'GY' => 'America/Guyana',
        'HT' => 'America/Port-au-Prince',
        'HN' => 'America/Tegucigalpa',
        'HK' => 'Asia/Hong_Kong',
        'HU' => 'Europe/Budapest',
        'IS' => 'Atlantic/Reykjavik',
        'IN' => 'Asia/Kolkata',
        'ID' => 'Asia/Jakarta',
        'IR' => 'Asia/Tehran',
        'IQ' => 'Asia/Baghdad',
        'IE' => 'Europe/Dublin',
        'IL' => 'Asia/Jerusalem',
        'IT' => 'Europe/Rome',
        'JM' => 'America/Jamaica',
        'JP' => 'Asia/Tokyo',
        'JO' => 'Asia/Amman',
        'KZ' => 'Asia/Almaty',
        'KE' => 'Africa/Nairobi',
        'KI' => 'Pacific/Tarawa',
        'KP' => 'Asia/Pyongyang',
        'KR' => 'Asia/Seoul',
        'KW' => 'Asia/Kuwait',
        'KG' => 'Asia/Bishkek',
        'LA' => 'Asia/Vientiane',
        'LV' => 'Europe/Riga',
        'LB' => 'Asia/Beirut',
        'LS' => 'Africa/Maseru',
        'LR' => 'Africa/Monrovia',
        'LY' => 'Africa/Tripoli',
        'LI' => 'Europe/Vaduz',
        'LT' => 'Europe/Vilnius',
        'LU' => 'Europe/Luxembourg',
        'MG' => 'Indian/Antananarivo',
        'MW' => 'Africa/Blantyre',
        'MY' => 'Asia/Kuala_Lumpur',
        'MV' => 'Indian/Maldives',
        'ML' => 'Africa/Bamako',
        'MT' => 'Europe/Malta',
        'MH' => 'Pacific/Majuro',
        'MR' => 'Africa/Nouakchott',
        'MU' => 'Indian/Mauritius',
        'MX' => 'America/Mexico_City',
        'FM' => 'Pacific/Pohnpei',
        'MD' => 'Europe/Chisinau',
        'MC' => 'Europe/Monaco',
        'MN' => 'Asia/Ulaanbaatar',
        'ME' => 'Europe/Podgorica',
        'MA' => 'Africa/Casablanca',
        'MZ' => 'Africa/Maputo',
        'MM' => 'Asia/Yangon',
        'NA' => 'Africa/Windhoek',
        'NR' => 'Pacific/Nauru',
        'NP' => 'Asia/Kathmandu',
        'NL' => 'Europe/Amsterdam',
        'NZ' => 'Pacific/Auckland',
        'NI' => 'America/Managua',
        'NE' => 'Africa/Niamey',
        'NG' => 'Africa/Lagos',
        'NO' => 'Europe/Oslo',
        'OM' => 'Asia/Muscat',
        'PK' => 'Asia/Karachi',
        'PW' => 'Pacific/Palau',
        'PS' => 'Asia/Gaza',
        'PA' => 'America/Panama',
        'PG' => 'Pacific/Port_Moresby',
        'PY' => 'America/Asuncion',
        'PE' => 'America/Lima',
        'PH' => 'Asia/Manila',
        'PL' => 'Europe/Warsaw',
        'PT' => 'Europe/Lisbon',
        'QA' => 'Asia/Qatar',
        'RO' => 'Europe/Bucharest',
        'RU' => 'Europe/Moscow',
        'RW' => 'Africa/Kigali',
        'KN' => 'America/St_Kitts',
        'LC' => 'America/St_Lucia',
        'VC' => 'America/St_Vincent',
        'WS' => 'Pacific/Apia',
        'SM' => 'Europe/San_Marino',
        'ST' => 'Africa/Sao_Tome',
        'SA' => 'Asia/Riyadh',
        'SN' => 'Africa/Dakar',
        'RS' => 'Europe/Belgrade',
        'SC' => 'Indian/Mahe',
        'SL' => 'Africa/Freetown',
        'SG' => 'Asia/Singapore',
        'SK' => 'Europe/Bratislava',
        'SI' => 'Europe/Ljubljana',
        'SB' => 'Pacific/Guadalcanal',
        'SO' => 'Africa/Mogadishu',
        'ZA' => 'Africa/Johannesburg',
        'ES' => 'Europe/Madrid',
        'LK' => 'Asia/Colombo',
        'SD' => 'Africa/Khartoum',
        'SR' => 'America/Paramaribo',
        'SE' => 'Europe/Stockholm',
        'CH' => 'Europe/Zurich',
        'SY' => 'Asia/Damascus',
        'TW' => 'Asia/Taipei',
        'TJ' => 'Asia/Dushanbe',
        'TZ' => 'Africa/Dar_es_Salaam',
        'TH' => 'Asia/Bangkok',
        'TL' => 'Asia/Dili',
        'TG' => 'Africa/Lome',
        'TO' => 'Pacific/Tongatapu',
        'TT' => 'America/Port_of_Spain',
        'TN' => 'Africa/Tunis',
        'TR' => 'Europe/Istanbul',
        'TM' => 'Asia/Ashgabat',
        'TV' => 'Pacific/Funafuti',
        'UG' => 'Africa/Kampala',
        'UA' => 'Europe/Kyiv',
        'AE' => 'Asia/Dubai',
        'GB' => 'Europe/London',
        'US' => 'America/New_York',
        'UY' => 'America/Montevideo',
        'UZ' => 'Asia/Tashkent',
        'VU' => 'Pacific/Efate',
        'VE' => 'America/Caracas',
        'VN' => 'Asia/Ho_Chi_Minh',
        'EH' => 'Africa/El_Aaiun',
        'YE' => 'Asia/Aden',
        'ZM' => 'Africa/Lusaka',
        'ZW' => 'Africa/Harare',
    ];









// ======================
function getTimeOffsetByCountryCode($countryCode) {
    // Full mapping of country codes to representative time zones
    $countryToTimeZone = [
        'AF' => 'Asia/Kabul',
        'AL' => 'Europe/Tirane',
        'DZ' => 'Africa/Algiers',
        'AS' => 'Pacific/Pago_Pago',
        'AD' => 'Europe/Andorra',
        'AO' => 'Africa/Luanda',
        'AG' => 'America/Antigua',
        'AR' => 'America/Argentina/Buenos_Aires',
        'AM' => 'Asia/Yerevan',
        'AU' => 'Australia/Sydney',
        'AT' => 'Europe/Vienna',
        'AZ' => 'Asia/Baku',
        'BS' => 'America/Nassau',
        'BH' => 'Asia/Bahrain',
        'BD' => 'Asia/Dhaka',
        'BB' => 'America/Barbados',
        'BY' => 'Europe/Minsk',
        'BE' => 'Europe/Brussels',
        'BZ' => 'America/Belize',
        'BJ' => 'Africa/Porto-Novo',
        'BT' => 'Asia/Thimphu',
        'BO' => 'America/La_Paz',
        'BA' => 'Europe/Sarajevo',
        'BW' => 'Africa/Gaborone',
        'BR' => 'America/Sao_Paulo',
        'BN' => 'Asia/Brunei',
        'BG' => 'Europe/Sofia',
        'BF' => 'Africa/Ouagadougou',
        'BI' => 'Africa/Bujumbura',
        'KH' => 'Asia/Phnom_Penh',
        'CM' => 'Africa/Douala',
        'CA' => 'America/Toronto',
        'CV' => 'Atlantic/Cape_Verde',
        'CF' => 'Africa/Bangui',
        'TD' => 'Africa/Ndjamena',
        'CL' => 'America/Santiago',
        'CN' => 'Asia/Shanghai',
        'CO' => 'America/Bogota',
        'KM' => 'Indian/Comoro',
        'CG' => 'Africa/Brazzaville',
        'CR' => 'America/Costa_Rica',
        'CI' => 'Africa/Abidjan',
        'HR' => 'Europe/Zagreb',
        'CU' => 'America/Havana',
        'CY' => 'Asia/Nicosia',
        'CZ' => 'Europe/Prague',
        'DK' => 'Europe/Copenhagen',
        'DJ' => 'Africa/Djibouti',
        'DM' => 'America/Dominica',
        'DO' => 'America/Santo_Domingo',
        'EC' => 'America/Guayaquil',
        'EG' => 'Africa/Cairo',
        'SV' => 'America/El_Salvador',
        'GQ' => 'Africa/Malabo',
        'ER' => 'Africa/Asmara',
        'EE' => 'Europe/Tallinn',
        'ET' => 'Africa/Addis_Ababa',
        'FJ' => 'Pacific/Fiji',
        'FI' => 'Europe/Helsinki',
        'FR' => 'Europe/Paris',
        'GA' => 'Africa/Libreville',
        'GM' => 'Africa/Banjul',
        'GE' => 'Asia/Tbilisi',
        'DE' => 'Europe/Berlin',
        'GH' => 'Africa/Accra',
        'GR' => 'Europe/Athens',
        'GT' => 'America/Guatemala',
        'GN' => 'Africa/Conakry',
        'GW' => 'Africa/Bissau',
        'GY' => 'America/Guyana',
        'HT' => 'America/Port-au-Prince',
        'HN' => 'America/Tegucigalpa',
        'HK' => 'Asia/Hong_Kong',
        'HU' => 'Europe/Budapest',
        'IS' => 'Atlantic/Reykjavik',
        'IN' => 'Asia/Kolkata',
        'ID' => 'Asia/Jakarta',
        'IR' => 'Asia/Tehran',
        'IQ' => 'Asia/Baghdad',
        'IE' => 'Europe/Dublin',
        'IL' => 'Asia/Jerusalem',
        'IT' => 'Europe/Rome',
        'JM' => 'America/Jamaica',
        'JP' => 'Asia/Tokyo',
        'JO' => 'Asia/Amman',
        'KZ' => 'Asia/Almaty',
        'KE' => 'Africa/Nairobi',
        'KI' => 'Pacific/Tarawa',
        'KP' => 'Asia/Pyongyang',
        'KR' => 'Asia/Seoul',
        'KW' => 'Asia/Kuwait',
        'KG' => 'Asia/Bishkek',
        'LA' => 'Asia/Vientiane',
        'LV' => 'Europe/Riga',
        'LB' => 'Asia/Beirut',
        'LS' => 'Africa/Maseru',
        'LR' => 'Africa/Monrovia',
        'LY' => 'Africa/Tripoli',
        'LI' => 'Europe/Vaduz',
        'LT' => 'Europe/Vilnius',
        'LU' => 'Europe/Luxembourg',
        'MG' => 'Indian/Antananarivo',
        'MW' => 'Africa/Blantyre',
        'MY' => 'Asia/Kuala_Lumpur',
        'MV' => 'Indian/Maldives',
        'ML' => 'Africa/Bamako',
        'MT' => 'Europe/Malta',
        'MH' => 'Pacific/Majuro',
        'MR' => 'Africa/Nouakchott',
        'MU' => 'Indian/Mauritius',
        'MX' => 'America/Mexico_City',
        'FM' => 'Pacific/Pohnpei',
        'MD' => 'Europe/Chisinau',
        'MC' => 'Europe/Monaco',
        'MN' => 'Asia/Ulaanbaatar',
        'ME' => 'Europe/Podgorica',
        'MA' => 'Africa/Casablanca',
        'MZ' => 'Africa/Maputo',
        'MM' => 'Asia/Yangon',
        'NA' => 'Africa/Windhoek',
        'NR' => 'Pacific/Nauru',
        'NP' => 'Asia/Kathmandu',
        'NL' => 'Europe/Amsterdam',
        'NZ' => 'Pacific/Auckland',
        'NI' => 'America/Managua',
        'NE' => 'Africa/Niamey',
        'NG' => 'Africa/Lagos',
        'NO' => 'Europe/Oslo',
        'OM' => 'Asia/Muscat',
        'PK' => 'Asia/Karachi',
        'PW' => 'Pacific/Palau',
        'PS' => 'Asia/Gaza',
        'PA' => 'America/Panama',
        'PG' => 'Pacific/Port_Moresby',
        'PY' => 'America/Asuncion',
        'PE' => 'America/Lima',
        'PH' => 'Asia/Manila',
        'PL' => 'Europe/Warsaw',
        'PT' => 'Europe/Lisbon',
        'QA' => 'Asia/Qatar',
        'RO' => 'Europe/Bucharest',
        'RU' => 'Europe/Moscow',
        'RW' => 'Africa/Kigali',
        'KN' => 'America/St_Kitts',
        'LC' => 'America/St_Lucia',
        'VC' => 'America/St_Vincent',
        'WS' => 'Pacific/Apia',
        'SM' => 'Europe/San_Marino',
        'ST' => 'Africa/Sao_Tome',
        'SA' => 'Asia/Riyadh',
        'SN' => 'Africa/Dakar',
        'RS' => 'Europe/Belgrade',
        'SC' => 'Indian/Mahe',
        'SL' => 'Africa/Freetown',
        'SG' => 'Asia/Singapore',
        'SK' => 'Europe/Bratislava',
        'SI' => 'Europe/Ljubljana',
        'SB' => 'Pacific/Guadalcanal',
        'SO' => 'Africa/Mogadishu',
        'ZA' => 'Africa/Johannesburg',
        'ES' => 'Europe/Madrid',
        'LK' => 'Asia/Colombo',
        'SD' => 'Africa/Khartoum',
        'SR' => 'America/Paramaribo',
        'SE' => 'Europe/Stockholm',
        'CH' => 'Europe/Zurich',
        'SY' => 'Asia/Damascus',
        'TW' => 'Asia/Taipei',
        'TJ' => 'Asia/Dushanbe',
        'TZ' => 'Africa/Dar_es_Salaam',
        'TH' => 'Asia/Bangkok',
        'TL' => 'Asia/Dili',
        'TG' => 'Africa/Lome',
        'TO' => 'Pacific/Tongatapu',
        'TT' => 'America/Port_of_Spain',
        'TN' => 'Africa/Tunis',
        'TR' => 'Europe/Istanbul',
        'TM' => 'Asia/Ashgabat',
        'TV' => 'Pacific/Funafuti',
        'UG' => 'Africa/Kampala',
        'UA' => 'Europe/Kyiv',
        'AE' => 'Asia/Dubai',
        'GB' => 'Europe/London',
        'US' => 'America/New_York',
        'UY' => 'America/Montevideo',
        'UZ' => 'Asia/Tashkent',
        'VU' => 'Pacific/Efate',
        'VE' => 'America/Caracas',
        'VN' => 'Asia/Ho_Chi_Minh',
        'EH' => 'Africa/El_Aaiun',
        'YE' => 'Asia/Aden',
        'ZM' => 'Africa/Lusaka',
        'ZW' => 'Africa/Harare',
    ];

    // Default time zone if country code is not found
    $defaultTimeZone = 'UTC';

    // Normalize the country code to uppercase
    $countryCode = strtoupper($countryCode);

    // Get the time zone for the country or default
    $timeZone = $countryToTimeZone[$countryCode] ?? $defaultTimeZone;

    try {
        // Create a DateTimeZone object
        $tz = new DateTimeZone($timeZone);
        $now = new DateTime("now", $tz);
        $offsetInSeconds = $tz->getOffset($now);

        // Convert offset from seconds to hours and minutes
        $hours = intdiv($offsetInSeconds, 3600);
        $minutes = abs($offsetInSeconds % 3600 / 60);

        // Return formatted offset
        return sprintf("%+d hours %d minutes", $hours, $minutes);
    } catch (Exception $e) {
        // Fallback in case of an error
        return '+0 hours 0 minutes';
    }
}

// Example usage
// $countryCode = 'IN'; // Replace with desired country code
// $timeOffset = getTimeOffsetByCountryCode($countryCode);
// echo "Time offset for {$countryCode}: {$timeOffset}";


function getCountryCode($ip = null) {
    if ($ip === null) {
        $ip = $_SERVER['REMOTE_ADDR'];
    }

    $defaultCountryCode = "IN";

    if ($ip === '127.0.0.1' || $ip === '::1') {
        return $defaultCountryCode;
    }

    $url = "http://ip-api.com/json/{$ip}?fields=countryCode";

    try {
        $response = file_get_contents($url);
        if ($response !== false) {
            $data = json_decode($response, true);
            return $data['countryCode'] ?? $defaultCountryCode;
        }
    } catch (Exception $e) {
        error_log("Error fetching country code: " . $e->getMessage());
    }
    // echo "<br>ip =  $ip</br>";
    return $defaultCountryCode;
}

// Usage
$countryCode = getCountryCode(@$IP);
// echo "<br>";
// echo "Country Code: " . $countryCode;
// echo "<br>";
// echo "zone for "$countryToTimeZone->$countryCode;
 $timeOffset = getTimeOffsetByCountryCode($countryCode);
// echo "<br>";
// echo 'formate'.$timeOffset1 =  number_format(($h = floor(strtotime($timeOffset) / 3600)) + (floor((strtotime($timeOffset) % 3600) / 60) / 60), 2);

// ---------------------------------------------

$time = $timeOffset;
$timeInDecimal = 0;

// Convert the time to seconds
$seconds = strtotime($time, 0);

// Convert seconds to hours and minutes
$hours = floor($seconds / 3600); // Full hours
$minutes = ($seconds % 3600) / 60; // Remaining minutes

// Combine hours and minutes into "H.MM" format
$timeFormatted = $hours . '.' . str_pad($minutes, 2, '0', STR_PAD_LEFT);

// echo $timeFormatted; // Output: $timeFormatted

// ---------------test date ------------------

$IP = get_client_ip();;
// echo "<br>IP = $IP<br>";

// echo date('Y-m-d H:i:s');
// echo "<br>";
// print_r($countryToTimeZone[$countryCode]);
date_default_timezone_set($countryToTimeZone[$countryCode]);
// echo "<br> changed date";
// echo date('Y-m-d H:i:s');
// date_default_timezone_set()
// echo "changed zone time ".;
// ---------------------------------------------
// echo "</br>";
// ======================
if(isset($_GET['d'])){

 $fordate_formate = $_GET['d'];
  $dattt = str_replace("/","-",$fordate_formate);;
// echo "<br>";

// ----------------------
// Using DateTime to ensure correct parsing
$datenewtemp = DateTime::createFromFormat("d-m-Y", $dattt);

if ($datenewtemp) {
      $fordate = $datenewtemp->format("Ymd"); // Outputs: 20250218
} else {
     // "Invalid date format!";
}
// ----------------------
// echo $fordate = date("Ymd", strtotime($dattt));  
}else{  
  $_GET['d'] = $fordate_formate;
}

if (!function_exists('dd')) {
 function dd()
  {
      echo '<pre>';
      array_map(function($x) {var_dump($x);}, func_get_args());
      die;
   }
 }

// print_r($fordate_formate);
 // dd(3);

function get_value($url){
//  $curl = curl_init();
// curl_setopt_array($curl, array(
//   CURLOPT_URL => $url,
//   CURLOPT_RETURNTRANSFER => true,
//   CURLOPT_ENCODING => '',
//   CURLOPT_MAXREDIRS => 10,
//   CURLOPT_TIMEOUT => 0,
//   CURLOPT_FOLLOWLOCATION => true,
//   CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
//   CURLOPT_CUSTOMREQUEST => 'GET',
// ));

// $response = curl_exec($curl);

// curl_close($curl);
// return $response;
// ===============================
$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => $url,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
));

$response = curl_exec($curl);

curl_close($curl);
return $response;


}
function get_value1($url){
$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => $url,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
));

$response = curl_exec($curl);

curl_close($curl);
return $response;



}



function json_to_array($data){
$data_value = json_decode($data);

return $data_value;

}

function region_value($data){
    $value = $data->Categories;

    return $value;
}
function team_value($data){
    $value = $data->Teams;

    return $value;
}

function competition_value($data){
    $value = $data->Stages;

    return $value;
}

function football_main_value($data){
    $value = $data->Stages;

    return $value;
}

// https://www.livescore.com/en/
// $main = 'https://prod-public-api.livescore.com/v1/api/app/date/soccer/20240717/$timeFormatted?locale=en&MD=1';

   $football_main = "https://prod-public-api.livescore.com/v1/api/app/date/soccer/$fordate/$timeFormatted?locale=en&MD=1";
$REGION_DETAIL_URL =  'https://prod-cdn-public-api.livescore.com/v1/api/app/category-s/soccer';
https://www.livescore.com/api/leftmenu/en/soccer/Spain
// https://www.livescore.com/api/leftmenu/en/soccer/england

// https://search-api.livescore.com
$base = "https://prod-cdn-search-api.livescore.com";
$region = "$base/api/v2/search/soccer/category?limit=20&locale=en&countryCode=$countryCode&sStages=true";
$team = "$base/api/v2/search/soccer/team?limit=20&locale=en&countryCode=$countryCode&sCategories=true&sStages=true";
$competition = "$base/api/v2/search/soccer/stage?limit=20&locale=en&countryCode=$countryCode&sCategories=true&sTeams=true";
// echo get_value($country);

// get region


$values = get_value($region);
$array_value = json_to_array($values);

$DATA['REGION'] =   region_value($array_value); //Cnm //Cid //CnmT  //Ccd

$values = get_value($team);
$array_value = json_to_array($values);
$DATA['TEAM'] =   team_value($array_value); //{"ID":"2810","Nm":"Manchester United","CoNm":"England","CoId":"ENG","Abr":"MUN","firstColor":"ea0000","secondColor":"ffffff","Img":"enet/10260.png"}


$values = get_value($competition);
$array_value = json_to_array($values);
$DATA['COMPETITION'] =   competition_value($array_value); //{"Sid":"18173","Snm":"Premier League","Sds":"Premier League","Scd":"premier-league","Cnm":"England","CnmT":"england","Ccd":"england","Cid":"34","Scu":0,"CompId":"65","CompN":"Premier League","CompD":"England","CompST":"England","badgeUrl":"2023-premier-league.png","firstColor":"3F1152"}


$values = get_value($football_main);
$array_value = json_to_array($values);
$DATA['FOOTBALL_MAIN'] =   football_main_value($array_value); 
// {"Sid":"18223","Snm":"Qualification","Scd":"qualification","badgeUrl":"europa-league-2024.png","firstColor":"B44A1E","Cnm":"Europa League","CnmT":"europa-league","Csnm":"Europa League","Ccd":"europa-league","CompId":"36","CompN":"Europa League","CompD":"UEFA","Scu":1,"Events":[{"Eid":"1310116","Pids":{"112":"SBTE_2_1021346996","8":"1310116"},"Media":{"112":[{"eventId":"4kr6fvxsv5ccfthaw759e5tec","provider":"UNKNOWN_PROVIDER","type":"LIVE_STREAMING","allowedCountries":["NG","NL"]}]},"Tr1":"2","Tr2":"0","Trh1":"1","Trh2":"0","Tr1OR":"2","Tr2OR":"0","T1":[{"Nm":"Dinamo Minsk","ID":"8097","Img":"enet/10058.png","Abr":"DIN"}],"T2":[{"Nm":"Lincoln Red Imps FC","ID":"4513","Img":"enet/545012.png","Abr":"LIN"}],"Eps":"FT","Esid":6,"Epr":2,"Ecov":0,"ErnInf":"3","Ewt":1,"Et":1,"Esd":20240809001500,"EO":269634429,"EOX":269634429,"Spid":1,"Pid":8},{"Eid":"1310125","Pids":{"112":"SBTE_2_1021347223","8":"1310125"},"Tr1":"0","Tr2":"0","Trh1":"0","Trh2":"0","Tr1OR":"0","Tr2OR":"0","T1":[{"Nm":"SC Braga","ID":"4270","Img":"enet/10264.png","Abr":"SBR"}],"T2":[{"Nm":"Servette","ID":"6","Img":"enet/9777.png","NewsTag":"/team/servette-2022062716001253418-475/","Abr":"SER"}],"Eps":"FT","Esid":6,"Epr":2,"Ecov":0,"ErnInf":"3","Ewt":0,"Et":1,"Esd":20240809010000,"EO":269665149,"EOX":269665149,"Spid":1,"Pid":8}]}












function camel($s){
  $field = "IMACSuperSeriousLabelDCN";
$label = preg_replace('/(?<=[a-z])[A-Z]|[A-Z](?=[a-z])/', ' $0', $s);
return  $label;
}

if (!function_exists('percent')) {
function percent($total,$percent){
$percentage = $percent;
$totalWidth = $total;

return $new_width = ($percentage / 100) * $totalWidth;
}
}

function get_percent($total,$value){
$percentage = $value;
$totalWidth = $total;
if(!$totalWidth){
  return 0;
}

return $new_width = ($percentage / $totalWidth) * 100;
}

function formate_url($s){

 $txt = str_replace(" ","-",$s);
 $txt = str_replace("'","",$txt);
return strtolower($txt);
}

function datet($s){
return date('d M', $s);
}
function dateh($s){
return date('H:i', $s);
}

function datef($s){
// $formattedDate = date('d M Y', strtotime($s));
$formattedDate = date('d M Y', strtotime(str_replace('/', '-', $s)));

return $formattedDate; // Outputs: 24 Oct 2024
}

function datesdt($s){
global $timeOffset;
// Create a DateTime object using the specified format
$date = DateTime::createFromFormat('YmdHis', $s);
// $newTime = date('Y-m-d H:i:s', strtotime($timeOffset));
// Format the date as "Y-m-d H:i:s" or any other preferred format
$formate["full"] = $date->format('Y-m-d H:i:s'); // Outputs: 2024-10-30 19:45:00

$date = new DateTime($formate["full"]);

// Add 6 hours and 10 minutes
$date->modify($timeOffset);



$formate["date"] =  $date->format('Y-m-d');   // Outputs: 2024-10-30 19:45:00
$formate["time"] =  $date->format('H:i:s');  // Outputs: 2024-10-30 19:45:00
$formate["time1"] =  $date->format('H:i');  // Outputs: 2024-10-30 19:45:00
$formate["formate"] =  $date->format('d M');   // Outputs: 2024-10-30 19:45:00
$formate["formate1"] =  $date->format('d M Y');   // Outputs: 2024-10-30 19:45:00

return $formate;
}